from django.apps import apps

from staff.lib.utils import initialize


initialize('handlers')


def smart_model(model_or_string):
    if isinstance(model_or_string, str):
        model = apps.get_model(*model_or_string.split('.', 1))
    else:
        model = model_or_string
    return model


# noinspection PyProtectedMember
def verbose_name(model_or_string, field):
    model = smart_model(model_or_string)

    split = field.split('__')
    models = split[:-1]  # all but last
    last_field = split[-1]

    for field_name in models:
        model = model._meta.get_field(field_name).rel.to

    return model._meta.get_field(last_field).verbose_name


__all__ = ()
