from django.db.models import Manager


class FilterManager(Manager):
    def __init__(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs
        super(FilterManager, self).__init__()

    def get_queryset(self):
        return (
            super(FilterManager, self)
            .get_queryset()
            .filter(*self.args, **self.kwargs)
        )
