from operator import or_
from django.db.models import Q


def build_search_query(query_string, search_fields, operator=or_):
    result = Q()
    for word in query_string.split():
        sub_q = build_subquery(word, search_fields)
        result = operator(result, sub_q)
    return result


def build_subquery(word, search_fields):
    result = Q()
    for field in search_fields:
        result |= Q(**{field + '__icontains': word})
    return result
