from functools import wraps

from django.http import JsonResponse

from staff.budget_position.workflow_service import OEBSError
from staff.lib.forms.errors import sform_general_error


def wrap_oebs_errors(view):
    @wraps(view)
    def wrapper(request, *args, **kwargs):
        try:
            return view(request, *args, **kwargs)
        except OEBSError as e:
            return JsonResponse(sform_general_error('oebs-error', params={'message': str(e)}), status=434)

    return wrapper
