from django.db import transaction


def take_pg_lock(lock_name: str, transaction_timeout_ms: int, lock_wait_timeout_ms: int):
    """
    :param lock_name: имя лока
    :param transaction_timeout_ms: максимальная продолжительность транзакции, потом сервер разорвет соединение
    приложение не узнает об этом до следующего обращения к базе
    :param lock_wait_timeout_ms: максимальная продолжительность ожидания лока

    Взятый лок не будет отпущен до окончания транзакции
    """
    connection = transaction.get_connection()
    # Лок работает только внутри транзакции
    assert connection.in_atomic_block

    cursor = connection.cursor()
    # Выплюнет InternalError: terminating connection due to idle-in-transaction timeout при обращении в базу
    # если транзакция не завершится за transaction_timeout_ms
    # используем SET LOCAL т.к действие SET LOCAL продолжается только до конца текущей транзакции,
    # независимо от того, фиксируется она или нет
    cursor.execute('SET LOCAL idle_in_transaction_session_timeout TO %s', (transaction_timeout_ms,))
    cursor.execute('SET LOCAL lock_timeout TO %s', (lock_wait_timeout_ms,))
    cursor.execute("SELECT pg_advisory_lock(('x' || md5(%s))::bit(64)::bigint)", (lock_name,))
