import json


def get_request_param(request, name):
    if request.method == 'GET':
        return request.GET.get(name)
    else:
        post_data = json.load(request)
        return post_data.get(name)


def get_list_request_param(request, name):
    """
    Получить списочное поле из реквеста.
    Для GET поддерживается формат '?val=1&val=2' или '?val=1,2'
    Для POST — ключ в json на первом уровне со значением-списком.
    """
    if request.method == 'GET':
        value_list = request.GET.getlist(name)
        if len(value_list) == 1:
            only_val = value_list[0]
            if ',' in only_val:
                return only_val.split(',')
        return value_list
    elif request.method == 'POST':
        post_data = json.load(request)
        return post_data.get(name)
