import logging
from typing import Optional

from django.conf import settings
from django.utils.functional import SimpleLazyObject
from ids.exceptions import BackendError
from startrek_client.objects import Resource

from staff.lib.requests import get_ids_repository


logger = logging.getLogger(__name__)


st_queues_repository = SimpleLazyObject(
    lambda: get_ids_repository(
        service='startrek2',
        resource_type='queues',
        oauth_token=settings.ROBOT_STAFF_OAUTH_TOKEN,
        user_agent=settings.STAFF_USER_AGENT,
        retries=3,
    )
)


def get_queue(queue: str) -> Optional[Resource]:
    try:
        queue = st_queues_repository.get_one(lookup={'id': queue})
    except BackendError:
        logger.warning('Error during create issue')
        return
    return queue
