from typing import Sequence, Tuple, Union, Callable, TypeVar, Dict


FieldName = str
FieldType = TypeVar('FieldType')
Converter = Callable[[FieldType], FieldType]
Predicate = Callable[[Dict], bool]

From = Tuple[FieldName]
FromTo = Tuple[FieldName, FieldName]
FromToConverter = Tuple[FieldName, FieldName, Converter]
FromToConverterPredicate = Tuple[FieldName, FieldName, Converter, Predicate]


def same_converter(value: FieldType) -> FieldType:
    return value


class DataMapper:
    mapping: Sequence[Union[From, FromTo, FromToConverter, FromToConverterPredicate]] = ()

    def __init__(self, object_dict: Dict):
        """
        @param object_dict: объект в виде дикта
        """
        self.object_dict = object_dict

    def iter_mapping(self):
        for entry in self.mapping:
            if len(entry) == 1:
                field, = entry
                yield field, field, same_converter

            elif len(entry) == 2:
                field_from, field_to = entry
                yield field_from, field_to, same_converter

            elif len(entry) == 3:
                yield entry

            elif len(entry) == 4:
                field_from, field_to, converter, predicate = entry
                if predicate(self.object_dict):
                    yield field_from, field_to, converter

    def __iter__(self):
        for field_from, field_to, converter in self.iter_mapping():
            value_from = self.object_dict.get(field_from)
            value_to = converter(value_from)
            yield field_to, value_to
