import logging

from staff.lib.sync_tools.diff_merger import DataDiffMerger
from staff.lib.utils.text import format_to_interpol


class Updater:
    datasource_class = None
    data_generator = None
    do_create = True
    do_update = True
    do_delete = True
    log_template = format_to_interpol(
        '{source_type} sync complete. '
        'Created: {created}, updated: {updated}, deleted: {deleted}, '
        'errors: {errors}, skipped: {skipped}, all: {all}'
    )
    source_type = 'UNKNOWN'

    def __init__(self, data_diff_merger: DataDiffMerger, logger):
        self._data_diff_merger = data_diff_merger
        self.logger = logger or logging.getLogger(__name__)

    def get_source_type(self):
        return self.source_type

    def run_sync(self):
        mode = {
            'create': self.do_create,
            'update': self.do_update,
            'delete': self.do_delete,
        }
        self._data_diff_merger.execute(**mode)

        results = self._data_diff_merger.results.copy()
        results['source_type'] = self.get_source_type()
        self.logger.info(self.log_template, results)
        return results
