from django import forms


class ValidatorForm(forms.Form):
    _warnings = None

    class Meta:
        warn_only_fields = ()

    @property
    def warnings(self):
        if self._warnings is None:
            self._filter_warnings()
        return self._warnings

    def _filter_warnings(self):
        self._warnings = {}
        for field_name in self.Meta.warn_only_fields:
            if field_name in self._errors:
                self._warnings[field_name] = self._errors.pop(field_name)
