from .dict import diff_dict, strip_prefix_in_keys, subdict

import os
import re

from django.conf import settings
from importlib import import_module


def initialize(*names):
    """Import modules and packages from INSTALLED_APPS, which names are in
    `names` list.
    """
    for app in settings.INSTALLED_APPS:
        m = import_module(app)

        for file_or_dir in os.listdir(os.path.split(m.__file__)[0]):
            python_name = re.sub(r'\.py$', '', file_or_dir)
            if python_name in names:
                try:
                    import_module(name='.' + python_name, package=app)
                except DeprecationWarning:
                    pass
                except ImportError:
                    pass


__all__ = (
    'initialize',
    'diff_dict',
    'strip_prefix_in_keys',
    'subdict',
)
