def strip_prefix_in_keys(dicts, prefix):
    for dct in dicts:
        new_dict = {}
        for key, val in dct.items():
            if key.startswith(prefix):
                new_key = key[len(prefix):]
                new_dict[new_key] = val
        yield new_dict


def diff_dict(dict_1, dict_2):
    return dict(set(dict_2.items()) - set(dict_1.items()))


def subdict(mapping, keys_sequence, default=None):
    """
    Возвращает dict, содержащий только ключи из списка
    и значения из исходного
    """
    def f(k):
        return k, mapping.get(k, default)
    pairs = map(f, keys_sequence)
    return dict(pairs)


def invert_dict(dictionary):
    """
    >>> invert_dict({'a': 1, 'b': 1, 'c': 'bar'})
    {1: ['a', 'b'], 'bar': ['c']}
    """
    res = {}
    for k, v in dictionary.items():
        vlist = res.setdefault(v, [])
        vlist.append(k)
    return res


def invert_multivaluedict(dictionary):
    """
    >>> invert_multivaluedict({'a': [1, 2], 'b': [1, 3], 'c': ['bar']})
    {1: ['a', 'b'], 2: ['a'], 3: ['b'],'bar': ['c']}
    """
    res = {}
    for k, v in dictionary.items():
        for vv in v:
            vlist = res.setdefault(vv, [])
            vlist.append(k)
    return res
