from enum import Enum


class EnumChoices(Enum):

    @classmethod
    def choices(cls):
        return tuple((i.value, i.value) for i in cls)

    @classmethod
    def dict(cls):
        return dict(cls.choices())

    @classmethod
    def get_name(cls, value):
        for item in cls:
            if item.value == value:
                return item.name
        raise KeyError(value)
