class Library(object):
    getters = ()

    def __init__(self, *getters):
        self._getters = getters or self.getters
        self._library = {}
        self._list = []

    def register(self, class_to_register):
        for getter in self._getters:
            key = getter(class_to_register)
            self._library[key] = class_to_register

        self._list.append(class_to_register)

        return class_to_register

    def __getitem__(self, key):
        if key in self._library:
            return self._library[key]
        else:
            raise KeyError(key)

    def __iter__(self):
        return iter(self._list)

    def get(self, key, default=None):
        try:
            return self[key]
        except KeyError:
            return default

    def keys(self):
        return self._library.keys()

    def __getattr__(self, attr):
        try:
            return self[attr]
        except KeyError:
            return super(Library, self).__getattr__(attr)
