import re


def methods_of(obj, name_pattern='.*'):
    for attr in dir(obj):
        if not re.match(name_pattern, attr):
            continue
        val = getattr(obj, attr)
        if callable(val):
            yield attr, val


class classproperty(object):
    def __init__(self, fget):
        self.fget = fget

    def __get__(self, instance, owner):
        return self.fget(owner)
