from staff.person.models import Staff

from staff.lib.utils.qs_values import extract_related
from staff.departments.utils import get_department_chain


VOLOZH_DEPARTMENTS_IDS = [
    2243,  # yandex_factory, YDF
    3013,  # yandex_int, International Development group
]


# https://st.yandex-team.ru/STAFF-7344 — страх и ужас
def is_volozh_kostyl(chief_login, person_login):
    if chief_login == 'volozh':
        department = Staff.objects.values(
            'login',
            'department__lft',
            'department__rght',
            'department__tree_id',
            'department__id',
        ).get(login=person_login)
        department = extract_related(department, 'department')
        dep_ids = [dep['id'] for dep in get_department_chain(**department)]
        if 4110 in dep_ids:  # yandex_exp, Experiments
            for dep_id in dep_ids:
                if dep_id in VOLOZH_DEPARTMENTS_IDS:
                    return False
            return True
    return False


def delegate_volozh_for_gap():
    return {'login': 'shulgin', 'work_email': 'shulgin@yandex-team.ru', 'id': 3030}
