import re


def format_to_interpol(template_string):
    """
    >>> format_to_interpol('foo: {foo}, bar: {bar}')
    'foo: %(foo)s, bar: %(bar)s'
    """
    return re.sub(r'\{([a-zA-Z0-9_]+)\}', r'%(\1)s', template_string)


def camel_to_underscore(string):
    """
    @type string: str | str
    @rtype: str | str

    >>> camel_to_underscore('ReadMeFist')
    'read_me_fist'
    >>> camel_to_underscore(u'KillAndRob_zombie')
    u'kill_and_rob_zombie'
    """
    def _gen():
        for index, char in enumerate(string):
            if char.isupper():
                if index:
                    yield '_'
                yield char.lower()
            else:
                yield char
    return string.__class__().join(_gen())


if __name__ == '__main__':
    import doctest
    doctest.testmod()
