from django.forms import ValidationError

from staff.person.models import Staff
from staff.departments.models import Department
from staff.map.models import Table, Room, Device, Region


def validate_login(value):
    if not Staff.objects.filter(login=value).exists():
        raise ValidationError('Нет сотрудника с логином %s' % value)


def validate_department_url(value):
    if not Department.objects.filter(url=value).exists():
        raise ValidationError('Нет подразделения с url %s' % value)


def validate_table_id(value):
    if not Table.objects.filter(id=value).exists():
        raise ValidationError('Нет стола с id %s' % value)


def validate_table_num(value):
    if not Table.objects.filter(num=value).exists():
        raise ValidationError('Нет стола с номером %s' % value)


def validate_room_num(value):
    if not Room.objects.filter(num=value).exists():
        raise ValidationError('Нет комнаты с номером %s' % value)


def validate_room_id(value):
    if not Room.objects.filter(id=value).exists():
        raise ValidationError('Нет комнаты с id %s' % value)


def validate_equipment_id(value):
    if not Device.objects.filter(id=value).exists():
        raise ValidationError('Нет оборудования с id %s' % value)


def validate_region_id(value):
    if not Region.objects.filter(id=value, intranet_status=1).exists():
        raise ValidationError('Нет области с номером %s' % value)
