import xlsxwriter

from staff.lib.xlsx.sheet_presenter import SheetPresenter


class View:
    """
    The view is a passive interface that displays data (the model)
    """
    def __init__(self, _presenter: SheetPresenter):
        self._presenter = _presenter

    @property
    def view_model(self) -> SheetPresenter:
        return self._presenter

    def write_to_workbook(self, workbook: xlsxwriter.Workbook):
        worksheet = workbook.add_worksheet(self._presenter.sheet_name)

        if self._presenter.outline_settings:
            worksheet.outline_settings(**self._presenter.outline_settings)

        if self._presenter.freeze_panes:
            worksheet.freeze_panes(**self._presenter.freeze_panes)

        for data_validation in self._presenter.data_validations:
            worksheet.data_validation(data_validation.coord, data_validation.validation)

        for idx, column in enumerate(self.view_model.columns()):
            worksheet.set_column(idx, idx, column.width, options=column.options)

        for row_idx, row in enumerate(self.view_model.rows()):
            for column_idx, cell in enumerate(row.cells):
                cell_format = workbook.add_format(cell.cell_format) if cell.cell_format else None
                if cell.url:
                    worksheet.write_url(row_idx, column_idx, cell.url, string=cell.text, cell_format=cell_format)
                else:
                    worksheet.write(row_idx, column_idx, cell.text, cell_format)

            if row.row_format:
                row_format = workbook.add_format(row.row_format) if row.row_format else None
                worksheet.set_row(row_idx, cell_format=row_format)

            if row.options:
                worksheet.set_row(row_idx, options=row.options)
