from typing import Iterable, Optional


class Column:
    def __init__(self, width: float = 8.43, options: Optional[dict] = None):
        self.width = width
        self.options = options or {}


class DataValidation:
    def __init__(self, coord, validate: str, source: str):
        self.coord = coord
        self.validate = validate
        self.source = source

    @property
    def validation(self) -> dict:
        return {
            'validate': self.validate,
            'source': self.source,
        }


class ViewCell:
    def __init__(self, text: str, cell_format: Optional[dict] = None, url: Optional[str] = None):
        self.cell_format = cell_format
        self.text = text
        self.url = url


class ViewRow:
    def __init__(self, cells: Iterable[ViewCell], options: Optional[dict] = None, row_format: dict = None):
        self.cells = cells
        self.options = options or {}
        self.row_format = row_format
