#!/usr/bin/env python3
import os
import sys

from staff.lib.deploy_log_variables import DEPLOY_VARIABLES
from staff.lib.log import log_context
from django.core.management import execute_from_command_line
from celery.__main__ import main as _celery_main


if 'DEPLOY_STAGE_ID' in os.environ and 'YENV_TYPE' not in os.environ:
    os.environ['YENV_TYPE'] = os.environ['DEPLOY_STAGE_ID']
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'staff.settings')


def django_main():
    execute_from_command_line(sys.argv)


def celery_main():
    with log_context(**DEPLOY_VARIABLES):
        return _celery_main()


if __name__ == "__main__":
    django_main()
