from typing import Any, Dict, Iterable

from staff.lib import xlsx

from staff.map.models import Room, ROOM_TYPES


_HEADINGS = (
    'room id',
    'room num',
    'room name',
    'room name alternative',
    'room type',
    'floor name',
    'office name',
    'office city',
)

_QUERY_FIELDS = (
    'id',
    'num',
    'name',
    'name_alternative',
    'room_type',
    'floor__name',
    'floor__office__name',
    'floor__office__city__name',
)


def rooms_export_model() -> Iterable[Room]:
    return Room.objects.active().values(*_QUERY_FIELDS).order_by('floor__office', 'floor', 'name')


class RoomsExportPresenter(xlsx.SheetPresenter):
    sheet_name = 'rooms_usage'

    def columns(self) -> Iterable[xlsx.Column]:
        return self.auto_columns()

    def rows(self) -> Iterable[xlsx.ViewRow]:
        yield self.column_captions_row()
        for model_row in self._model:
            row_with_room_type_text = self.with_room_type_text(model_row)
            yield self.default_view_row_from_row_data(row_with_room_type_text)

    def column_captions_row(self) -> xlsx.ViewRow:
        return self.default_view_row_from_row_data(_HEADINGS)

    def with_room_type_text(self, model_row: Dict[str, Any]) -> Iterable[Any]:
        model_row['room_type'] = str(ROOM_TYPES[model_row['room_type']])
        return model_row.values()
