from staff.lib.utils.qs_values import extract_related
from staff.map.controllers.room_common import update_room_common, create_room_common, delete_room_common
from staff.map.edit.objects import CoworkingRoomCtl, RoomCtl
from staff.map.errors import MapApiError, item_does_not_exist_by_id
from staff.map.models import Room, ROOM_TYPES

import logging
logger = logging.getLogger('map.controllers.coworking_room')


COWORKING_ROOM_FIELDS = (
    'num', 'name', 'name_en', 'additional',
    'coord_x', 'coord_y', 'floor', 'floor__office', 'geometry'
)


class CoworkingRoomError(MapApiError):
    pass


def get_initial(room_id=None):
    if room_id is None:
        return {}

    with item_does_not_exist_by_id(Room)(logger=logger, message_params=[room_id], raise_e=CoworkingRoomError):
        room = (
            Room.objects.values(*COWORKING_ROOM_FIELDS)
            .filter(room_type=ROOM_TYPES.COWORKING)
            .get(id=room_id, intranet_status=1)
        )
        room.update(extract_related(room, 'floor_'))
        return room


def update_coworkingroom(room_id, data, author):
    with item_does_not_exist_by_id(Room)(logger=logger, message_params=[room_id], raise_e=CoworkingRoomError):
        room = Room.objects.get(id=room_id, room_type=ROOM_TYPES.COWORKING)

    update_room_common(CoworkingRoomCtl, CoworkingRoomError, room, data, author)


def create_coworkingroom(data, author) -> RoomCtl:
    data['room_type'] = ROOM_TYPES.COWORKING
    return create_room_common(CoworkingRoomCtl, CoworkingRoomError, data, author)


def delete_coworkingroom(room_idid, author) -> RoomCtl:
    with item_does_not_exist_by_id(Room)(logger=logger, message_params=[room_idid], raise_e=CoworkingRoomError):
        room = Room.objects.get(id=room_idid, room_type=ROOM_TYPES.COWORKING, intranet_status=1)

    return delete_room_common(CoworkingRoomCtl, CoworkingRoomError, room, author)
