from django.contrib.gis.db.backends.postgis.base import DatabaseWrapper as PostgisWrapper
from django.contrib.gis.db.backends.postgis.schema import PostGISSchemaEditor
from django_pgaas.backend.base import DatabaseWrapper as PgaasWrapper

from staff.map.db_wrapper.operations import DatabaseOperations


class PostgisDatabaseWrapper(PgaasWrapper, PostgisWrapper):
    """pgaas-враппер, с поддержкой postgis
     - Не умеет в Zero Downtime Migrations (игнорирует settings.PGAAS_USE_ZDM)
     - requires psycopg2 as sql adapter
    """
    SchemaEditorClass = PostGISSchemaEditor

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.ops = DatabaseOperations(self)
        assert self.psycopg2_version
