import logging

import json

from staff.lib.forms.staff_form_grid import StaffFormGrid
from staff.lib.forms.errors import invalid_json_error, form_data_error

logger = logging.getLogger('staff.map.edit.base')


def load_data(request_body, form_cls, form_name, model, id=None):
    try:
        form_data = json.loads(request_body)[form_name][0]
    except ValueError:
        logger.exception('Wrong JSON: %s', request_body)
        return invalid_json_error(request_body), 400
    except (KeyError, IndexError):
        logger.exception('Cannot find form data: %s', form_name)
        return form_data_error(form_name), 400

    form_data['model'] = model
    if id:
        form_data['id'] = id
    grid = StaffFormGrid(form_cls, data=[form_data])

    if not grid.is_valid():
        return {'errors': {form_name: grid.errors()}}, 200

    return grid.cleaned_data, None
