from enum import Enum
from functools import partial
from typing import Dict, List

from staff.lib.exceptions import ErrorWithStatusCode
from staff.lib.forms.errors import LogException


class MapApiError(ErrorWithStatusCode):
    pass


class TableError(MapApiError):
    pass


class MultipleTableError(MapApiError):
    def __init__(self, errors: List[Dict], *args, **kwargs):
        self.errors = errors
        super().__init__(*args, **kwargs)


class TableBookConflictType(str, Enum):
    BOOK_OVERLAP = 'book-overlap-different-person'
    BOOK_OVERLAP_ONE_PERSON = 'book-overlap-one-person'
    STAFF_BOOKED_ANOTHER = 'staff-booked-another-table'


def item_does_not_exist_by_id(model):
    return partial(
        LogException,
        catch_e=model.DoesNotExist,
        message='Cannot find {modelname} by ID: %s'.format(modelname=model.__name__.lower()),
        status_code=404
    )
