import datetime

import sform

from django.conf import settings
from django.core.exceptions import ValidationError

from staff.person.models import Staff

from staff.map.models import Table


class BookTableForPersonForm(sform.SForm):
    person = sform.SuggestField(
        queryset=Staff.objects.active().filter(is_dismissed=False),
        to_field_name='login',
        label_fields=('login',),
        state=sform.REQUIRED,
    )

    table = sform.SuggestField(
        queryset=Table.objects.active(),
        to_field_name='num',
        label_fields=('num',),
        state=sform.REQUIRED,
    )

    date_from = sform.DateField(state=sform.NORMAL)
    date_to = sform.DateField(state=sform.NORMAL)

    @staticmethod
    def clean_date_from(value):
        if not value:
            return datetime.date.today()

        if value < datetime.date.today():
            raise ValidationError('Date from should not be in the past', 'past')

        return value

    @staticmethod
    def clean_date_to(value):
        if not value:
            return datetime.date.today()

        if value > datetime.date.today() + datetime.timedelta(days=settings.MAP_TABLE_MAX_BOOK_PERIOD_FROM_TODAY):
            raise ValidationError('Date from should not be in the past', 'two_weeks_exceeded')

        return value

    def clean(self):
        cleaned_data = self.cleaned_data

        if not self.is_valid():
            return cleaned_data

        if cleaned_data['date_to'] < cleaned_data['date_from']:
            raise ValidationError('Date to should be greater than date from', 'invalid_time_interval')

        return cleaned_data
