import re

from staff.lib.forms.staff_fields import (
    StaffBooleanField,
    StaffCharField,
    StaffIntegerField,
)

from staff.map.models import Room
from staff.map.forms.base import GeometryBaseMapEditForm


class ConferenceRoomForm(GeometryBaseMapEditForm):

    name = StaffCharField(max_length=255, required=True)
    name_en = StaffCharField(max_length=255, required=True)

    name_alternative = StaffCharField(max_length=255, required=False)
    name_exchange = StaffCharField(max_length=50, required=True)

    order = StaffIntegerField(required=False)
    is_cabin = StaffBooleanField(required=False)
    is_avallable_for_reserve = StaffBooleanField(required=False)

    marker_board = StaffBooleanField(required=False)
    cork_board = StaffBooleanField(required=False)

    phone = StaffCharField(max_length=50, required=False)
    video_conferencing = StaffCharField(max_length=50, required=False)

    guest_wifi = StaffBooleanField(required=False)
    voice_conferencing = StaffBooleanField(required=False)
    projector = StaffIntegerField(required=False)
    panel = StaffIntegerField(required=False)
    desk = StaffBooleanField(required=False)
    seats = StaffIntegerField(required=False)
    capacity = StaffIntegerField(required=False)

    additional = StaffCharField(required=False)

    def clean_name_exchange(self):
        name_exchange = self.cleaned_data.get('name_exchange')

        if '@' in name_exchange:
            self._errors['name_exchange'] = [
                '{"error_key": "map-conferenceroom_no_at_symbol"}'
            ]

        if not re.fullmatch(r'[a-z0-9_\-.]+', name_exchange):
            self._errors['name_exchange'] = [
                '{"error_key": "invalid"}'
            ]

        query = Room.objects.filter(name_exchange=name_exchange)
        if self.id:
            query = query.exclude(id=self.id)

        if query.exists():
            self._errors['name_exchange'] = [
                '{"error_key": "map-conferenceroom_duplicate_exchange_name"}'
            ]

        return name_exchange

    def clean_order(self):
        order = self.cleaned_data.get('order')
        floor = self.cleaned_data.get('floor')

        if order is None or floor is None:
            return order

        query = Room.objects.filter(
            floor__office_id=floor.office_id,
            floor__intranet_status=1,
            order=order, intranet_status=1
        )
        if self.id:
            query = query.exclude(id=self.id)

        if query.exists():
            self._errors['order'] = [
                '{"error_key": "map-conferenceroom_order_occupied"}'
            ]
        return order

    def clean_capacity(self):
        capacity = self.cleaned_data.get('capacity')
        seats = self.cleaned_data.get('seats')

        if not (capacity or seats):
            return capacity

        if not capacity:
            return seats

        if seats and capacity < seats:
            self._errors['capacity'] = [
                '{"error_key": "map-conferenceroom_capacity_error"}'
            ]

        return capacity

    def clean_voice_conferencing(self):
        phone = self.cleaned_data.get('phone')
        voice_conferencing = self.cleaned_data.get('voice_conferencing')

        if voice_conferencing and not phone:
            self._errors['voice_conferencing'] = [
                '{"error_key": "map-conferenceroom_phone_should_be_set"}'
            ]

        return voice_conferencing
