from staff.map.models import Room
from staff.map.forms.base import GeometryBaseMapEditForm
from staff.lib.forms.staff_fields import (
    StaffCharField,
    StaffIntegerField,
)


class CoworkingRoomForm(GeometryBaseMapEditForm):
    num = StaffIntegerField(required=False)
    name = StaffCharField(max_length=255, required=False)
    name_en = StaffCharField(max_length=255, required=False)
    additional = StaffCharField(required=False)

    def clean(self):
        cleaned_data = super(CoworkingRoomForm, self).clean()
        num = cleaned_data.get('num')
        floor = cleaned_data.get('floor')

        if num and floor:
            query = Room.objects.filter(
                floor__office_id=floor.office_id,
                floor__intranet_status=1,
                num=num, intranet_status=1
            )
            if self.id:
                query = query.exclude(id=self.id)
                if self.id is not None:
                    query = query.exclude(id=self.id)

                if query.exists():
                    self._errors['num'] = ['{"error_key": "map-room_duplicate"}']

        return cleaned_data
