from staff.lib.forms.staff_fields import (
    StaffCharField,
    StaffChoiceField,
    StaffIntegerField,
)

from staff.map.models import DEVICE_TYPES

from .base import BaseMapEditForm


class EquipmentForm(BaseMapEditForm):

    type = StaffChoiceField(
        choices=DEVICE_TYPES.choices(),
        required=True,
        initial=DEVICE_TYPES.PRINTER,
    )
    name = StaffCharField(required=True)
    name_dns = StaffCharField(required=False)
    description = StaffCharField(required=False)

    color = StaffCharField(max_length=10, required=False)

    angle = StaffIntegerField(min_value=0, max_value=359, initial=0)

    def clean(self):
        cleaned_data = super(EquipmentForm, self).clean()
        type = cleaned_data.get('type')
        cleaned_data['type'] = int(type)
        return cleaned_data
