from django.core.management.base import BaseCommand
from optparse import make_option

from staff.person.models import Staff


class Command(BaseCommand):
    help = "Get employee sitting on deleted tables"

    option_list = BaseCommand.option_list + (
        make_option(
            '--restore',
            '-r',
            action='store_true',
            dest='restore',
            default=False,
            help='Restore deleted tables with employee sitting on them',
        ),

        make_option(
            '--list',
            '-l',
            action='store_true',
            dest='list',
            default=False,
            help='List deleted tables with employee sitting on them',
        ),

        make_option(
            '--count',
            '-c',
            action='store_true',
            dest='count',
            default=False,
            help='Count deleted tables with employee sitting on them',
        ),
    )

    def handle(self, *args, **options):
        staff = Staff.objects.filter(is_dismissed=0, table__intranet_status=0)
        restore = options['restore']
        list_employees = options['list']
        count_employees = options['count']
        if count_employees:
            print(staff.count())

        if list_employees:
            staff = (
                staff.order_by('table__floor__office', 'table__floor__num').
                values('id', 'work_email', 'table__floor__num', 'table__floor__office__name')
            )
            print(';'.join(['id', 'login', 'office', 'floor']))

            for person in staff:
                print(';'.join([
                    str(person['id']),
                    str(person['work_email']),
                    str(person['table__floor__office__name']),
                    str(person['table__floor__num']),
                ]))

        if restore:
            for person in staff:
                table = person.table
                table.intranet_status = 1
                table.save()
