# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.contrib.gis.db.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'permissions': (('external_with_map_access', 'External with map access'),),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='FloorMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('file_name', models.CharField(max_length=255, unique=True)),
                ('is_ready', models.BooleanField(default=False)),
                ('max_zoom', models.IntegerField(default=5)),
                ('min_zoom', models.IntegerField(default=3)),
                ('zero_zoom', models.IntegerField(default=5)),
                ('tile_size', models.IntegerField(default=256)),
            ],
            options={
                'permissions': (('can_upload_floor_map', 'Can upload floor map'),),
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('model_name', models.CharField(max_length=255)),
                ('model_pk', models.IntegerField(null=True)),
                ('action', models.CharField(max_length=255, choices=[('created', 'CREATED'), ('updated', 'UPDATED'), ('disabled', 'DISABLED'), ('deleted', 'DELETED'), ('occupied', 'OCCUPIED')])),
                ('data', models.TextField(null=True)),
                ('created_at', models.DateTimeField(db_index=True, auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Placement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(verbose_name='Наименование расположения', max_length=255, blank=True, default='')),
                ('addr', models.CharField(verbose_name='Адрес', max_length=255, blank=True, default='')),
                ('active_status', models.BooleanField(verbose_name='Флаг наличия', default=False)),
                ('home_work', models.BooleanField(verbose_name='Флаг (надомник)', default=False)),
                ('office', models.ForeignKey(verbose_name='Офис', null=True, to='django_intranet_stuff.Office')),
                ('organization', models.ForeignKey(verbose_name='Юр.лицо', null=True, to='django_intranet_stuff.Organization')),
            ],
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('intranet_status', models.IntegerField(default=1)),
                ('name', models.CharField(max_length=255, default='')),
                ('description', models.TextField(blank=True)),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(srid=4326)),
                ('floor', models.ForeignKey(related_name='map_regions', to='django_intranet_stuff.Floor')),
                ('group', models.ForeignKey(null=True, default=None, related_name='map_regions', to='django_intranet_stuff.Group')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RoomUsage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('date', models.DateField()),
                ('usage', models.FloatField()),
                ('source', models.CharField(max_length=16, choices=[('whistlah', 'whistlah'), ('pacs', 'pacs')])),
                ('room', models.ForeignKey(verbose_name='комната', to='django_intranet_stuff.Room')),
            ],
        ),
        migrations.CreateModel(
            name='StaffOfficeLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('date', models.DateField()),
                ('source', models.CharField(max_length=16, choices=[('whistlah', 'whistlah'), ('pacs', 'pacs')])),
                ('is_weekend', models.BooleanField(default=False)),
                ('office', models.ForeignKey(to='django_intranet_stuff.Office')),
                ('staff', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
    ]
