from django.utils.translation import ugettext_lazy as _

from django.db import models
from staff.lib.utils.ordered_choices import OrderedChoices

from staff.lib.models.base import IntranetModel, IntranetManager


DEVICE_TYPES = OrderedChoices(
    ('PRINTER', 0, _('intranet_stuff.Device_Printer')),
    ('SCANNER', 1, _('intranet_stuff.Device_Scanner')),
    ('COPIER', 2, _('intranet_stuff.Device_Copier')),
    ('MFP', 3, _('intranet_stuff.Device_MFP')),
    ('DECT', 4, _('intranet_stuff.Device_DECT')),
    ('WIFI', 5, _('intranet_stuff.Device_WiFi')),
    ('RJ45', 6, _('intranet_stuff.Device_RJ45')),
    ('FAX', 7, _('intranet_stuff.Device_Fax')),
    ('SHREDDER', 8, _('intranet_stuff.Device_Shredder')),
    ('CCTV', 9, _('intranet_stuff.Device_CCTV')),
    ('STATIONERY_CABINET', 10, _('intranet_stuff.Device_Stationery')),
    ('LOCK', 11, _('intranet_stuff.Device_Lock')),
    ('HYPERCUBE', 12, _('intranet_stuff.Device_Hypercube')),
    ('SENSOR', 13, _('intranet_stuff.Device_Sensor')),
    ('ZOMBIE', 14, _('intranet_stuff.Device_Zombie')),
    ('WIFI_MOUNT_PLATFORM', 15, _('intranet_stuff.Device_WiFi_MountPlatform')),
    ('WIFI_SENSOR', 16, _('intranet_stuff.Device_WiFi_Sensor')),
    ('VENDING_MACHINE', 17, _('intranet_stuff.Device_Vending_Machine')),
    ('HELP_MACHINE', 18, _('intranet_stuff.Device_Help_Machine')),
    ('ATM', 19, _('intranet_stuff.Device_ATM')),
    ('MASSAGE_CHAIR', 20, _('intranet_stuff.Device_MassageChair')),
    ('BATTERY_RECYCLING_CONTAINER', 21, _('intranet_stuff.Device_BatteryRecyclingContainer')),
    ('SLEEP_CAPSULE', 22, _('intranet_staff.Device_SleepCapsule')),
    ('PHOTO_BOOTH', 23, _('intranet_staff.Device_PhotoBooth')),
    ('PHOTO_SPOT', 24, _('intranet_staff.Device_PhotoSpot')),
)

SECURITY_DEVICES = (
    DEVICE_TYPES.CCTV,
    DEVICE_TYPES.LOCK,
)


class DeviceManager(IntranetManager):
    def active_without_security_devices(self):
        return self.active().exclude(type__in=SECURITY_DEVICES)


class Device(IntranetModel):
    objects = DeviceManager()

    from_staff_id = models.PositiveIntegerField(db_index=True)
    floor = models.ForeignKey('django_intranet_stuff.Floor')
    type = models.PositiveSmallIntegerField(
        choices=DEVICE_TYPES.choices(),
        default=DEVICE_TYPES.PRINTER,
    )

    name = models.CharField(max_length=255)
    name_dns = models.CharField(max_length=255, default='')
    description = models.TextField(default='')
    coord_x = models.IntegerField(null=True)
    coord_y = models.IntegerField(null=True)
    color = models.CharField(max_length=10, default='')
    angle = models.PositiveSmallIntegerField(default=0)

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_printer'
