from django.db import models

from staff.lib.models.base import SortedModel, IntranetModel


class Floor(IntranetModel, SortedModel):
    from_staff_id = models.PositiveIntegerField(db_index=True)
    name = models.CharField(max_length=50)
    name_en = models.CharField(max_length=50, default='')
    num = models.IntegerField(null=True)
    office = models.ForeignKey('Office')
    coord_x = models.IntegerField(null=True)
    coord_y = models.IntegerField(null=True)
    img = models.CharField(max_length=1024, null=True, blank=True)

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_floor'
