from django.db import models
from django.conf import settings


class FloorMap(models.Model):
    class Meta:
        permissions = (
            ("can_upload_floor_map", 'Can upload floor map'),
        )

    created_at = models.DateTimeField(auto_now_add=True)
    floor = models.ForeignKey('django_intranet_stuff.Floor')
    file_name = models.CharField(max_length=255, unique=True)
    is_ready = models.BooleanField(default=False)

    max_zoom = models.IntegerField(default=settings.MAP_MAX_ZOOM)
    min_zoom = models.IntegerField(default=settings.MAP_MIN_ZOOM)
    zero_zoom = models.IntegerField(default=settings.MAP_ZERO_ZOOM)
    tile_size = models.IntegerField(default=settings.MAP_TILE_SIZE)
