from django.db import models

from staff.lib.models.base import ColoredModel, SortedModel, IntranetModel
from staff.lib.utils.ordered_choices import OrderedChoices


COUNTRY_CODES = OrderedChoices(
    ('RUSSIA', 'ru'),
    ('BELARUS', 'by'),
)


class City(IntranetModel, ColoredModel, SortedModel):
    name = models.CharField(max_length=100)
    name_en = models.CharField(max_length=100, default='', blank=True)
    geo_id = models.IntegerField(default=0)
    country = models.ForeignKey('django_intranet_stuff.Country', null=True, blank=True)

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_city'


class Country(IntranetModel, ColoredModel, SortedModel):
    name = models.CharField(max_length=100)
    name_en = models.CharField(max_length=100)
    yandex_domain = models.CharField(max_length=100)
    code = models.CharField(max_length=2, default='', blank=True)
    geo_base_id = models.IntegerField()

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_country'
