from django.conf import settings
from django.db import models

from staff.lib.models.base import SortedModel, IntranetModel
from staff.lib.utils.enum_choices import EnumChoices

from staff.person.models import Staff


class SourceTypes(EnumChoices):
    WHISTLAH = 'whistlah'
    PACS = 'pacs'


class Office(IntranetModel, SortedModel):
    from_staff_id = models.PositiveIntegerField(db_index=True)

    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, default='')

    is_virtual = models.BooleanField(default=False, verbose_name='Виртуальный')

    city = models.ForeignKey('City', null=True, blank=True)
    address1 = models.CharField(max_length=255, default='')
    address2 = models.CharField(max_length=255, default='')
    address1_en = models.CharField(max_length=255, default='')
    address2_en = models.CharField(max_length=255, default='')
    phone = models.CharField(max_length=50, default='')
    fax = models.CharField(max_length=50, default='')
    tz = models.CharField(max_length=20, default='')

    color = models.CharField(max_length=10)
    have_map = models.BooleanField(default=False)
    coord_x = models.FloatField(null=True)
    coord_y = models.FloatField(null=True)
    zoom = models.PositiveSmallIntegerField(default=0)
    code = models.CharField(max_length=20, default='')
    filter_id = models.CharField(max_length=40, default='', blank=True)

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_office'

    _HOMIE_OFFICE = None

    @classmethod
    def get_homie_office(cls):
        if cls._HOMIE_OFFICE is None:
            cls._HOMIE_OFFICE = Office.objects.get(id=settings.HOMIE_OFFICE_ID)
        return cls._HOMIE_OFFICE

    def get_country_code(self):
        return self.city.country.code


class StaffOfficeLog(models.Model):
    staff = models.ForeignKey(Staff)
    office = models.ForeignKey(Office)
    date = models.DateField()
    source = models.CharField(
        null=False,
        blank=False,
        max_length=16,
        choices=SourceTypes.choices(),
    )
    is_weekend = models.BooleanField(default=False, blank=True)

    class Meta:
        unique_together = ('staff', 'office', 'date', 'source')


class OfficePart(models.Model):
    main_office = models.ForeignKey(Office, null=False, related_name='office_parts')
    part_of_main_office = models.ForeignKey(Office, null=False)

    class Meta:
        unique_together = ('main_office', 'part_of_main_office')
