from django.db import models

from staff.person.models import Organization
from staff.map.models.office import Office


class Placement(models.Model):
    name = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Наименование расположения",
    )

    addr = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Адрес",
    )

    organization = models.ForeignKey(
        Organization,
        null=True,
        verbose_name='Юр.лицо',
    )

    office = models.ForeignKey(
        Office,
        null=True,
        verbose_name='Офис',
    )

    active_status = models.BooleanField(
        default=False,
        verbose_name="Флаг наличия",
    )

    home_work = models.BooleanField(
        default=False,
        verbose_name="Флаг (надомник)",
    )
