from django.contrib.gis.db import models as gis_models
from django.db import models

from staff.lib.models.base import DisSoftDeletedModel

from staff.map.models.floor import Floor


class Region(DisSoftDeletedModel):
    name = models.CharField(max_length=255, default='')
    description = models.TextField(blank=True)
    group = models.ForeignKey('django_intranet_stuff.Group', related_name='map_regions', null=True, default=None)
    floor = models.ForeignKey(Floor, related_name='map_regions', null=False)
    geometry = gis_models.MultiPolygonField()

    def __str__(self):
        return f'{self.name} on {self.floor}'
