from django.db import models

from staff.lib.models.base import IntranetModel


class Table(IntranetModel):
    from_staff_id = models.PositiveIntegerField(db_index=True)
    num = models.PositiveIntegerField(db_index=True)
    floor = models.ForeignKey('Floor', verbose_name='этаж')
    room = models.ForeignKey('Room', verbose_name='комната', null=True, blank=True)
    coord_x = models.IntegerField(null=True)
    coord_y = models.IntegerField(null=True)

    def __str__(self):
        return str(self.id)

    @property
    def geom_point(self) -> str:
        return f'POINT({self.coord_x} {self.coord_y})'

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_table'


class TableBook(models.Model):
    created_at = models.DateTimeField(editable=False)
    modified_at = models.DateTimeField(editable=False)
    staff = models.ForeignKey('Staff', related_name='table_book')
    table = models.ForeignKey('Table', related_name='table_book')
    description = models.CharField(max_length=255, default='')
    date_from = models.DateField()
    date_to = models.DateField()
    gap_id = models.IntegerField(null=True)

    class Meta:
        db_table = 'intranet_table_book'
        app_label = 'django_intranet_stuff'


class TableReserve(IntranetModel):
    table = models.ForeignKey('Table', related_name='table_reserve')
    department = models.ForeignKey('Department', related_name='table_reserve', null=True)
    staff = models.ForeignKey('Staff', related_name='table_reserve', null=True)
    description = models.CharField(max_length=255, default='')
    occupied_at = models.DateField(null=True)

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_table_reserve'
