from typing import Any, Optional


def geom_to_polygon(geometry: str) -> Optional[str]:
    """
    Преобразует геометрию комнаты со Стаффа вида `X1,Y1,...,Xn,Yn,X1,Y1`
    в полигон, который воспринимает Postgres: `POLYGON((X1 Y1, ..., Xn Yn, X1 Y1))`,
    при условии, что эта геометрия есть

    :returns: postgres-полигон или None, если нет геометрии
    """
    geometry = geometry.strip()
    if not geometry:
        return None
    try:
        coords: Any = map(int, geometry.split(','))
        coords = zip(*[iter(coords)] * 2)

        # 2048-y - это формула пересчета оси Y,
        # именно так на фронте строится вся геометрия
        coords = ", ".join([f'{x} {2048 - y}' for x, y in coords])
    except ValueError:
        return None

    return f"POLYGON(({coords}))"
