def get_user_permissions(user):
    prefix = 'django_intranet_stuff'

    permissions = {
        'table': {
            'can_add': 'add_table',
            'can_edit': 'change_table',
            'can_delete': 'delete_table',
            'can_occupy': 'change_table_occupation',
            },
        'room': {
            'can_add': 'add_room',
            'can_edit': 'change_room',
            'can_delete': 'delete_room',
            'can_bind': 'bind_room',  # если есть право пересадить за другой стол, то
                                      # есть и право пересадить в другую комнату
        },
        'region': {  # Пока что те же права что и на комнату
            'can_add': 'add_room',
            'can_edit': 'change_room',
            'can_delete': 'delete_room'
        },
        'conference_room': {
            'can_add': 'add_conference_room',
            'can_edit': 'change_conference_room',
            'can_delete': 'delete_conference_room'
        },
        'coworking_room': {
            'can_add': 'add_coworking_room',
            'can_edit': 'change_coworking_room',
            'can_delete': 'delete_coworking_room',
        },
        'device': {
            'can_add': 'add_device',
            'can_edit': 'change_device',
            'can_delete': 'delete_device'
        },
    }

    for entity in permissions:
        for p in permissions[entity]:
            permissions[entity][p] = user.has_perm('.'.join([prefix, permissions[entity][p]]))

    security_devices_permission = user.has_perm('django_intranet_stuff.can_add_security_devices')

    permissions['security_device'] = {
        'can_add': security_devices_permission,
        'can_edit': security_devices_permission,
        'can_delete': security_devices_permission,
    }

    can_manage_workspace_areas = user.has_perm('workspace_management.can_manage_workspace_areas')

    for room_type in ('coworking_room', 'conference_room', 'room'):
        permissions[room_type]['can_manage_workspace_areas'] = can_manage_workspace_areas

    return permissions
