from io import BytesIO

from django.conf import settings

import boto3

BUCKET_NAME = 'staff.map'


def init():
    session = boto3.session.Session(
        aws_access_key_id=settings.AWS_ACCESS_KEY_ID,
        aws_secret_access_key=settings.AWS_SECRET_ACCESS_KEY,
    )

    conn = session.resource(
        service_name='s3',
        endpoint_url=settings.S3_HOST,
    )
    bucket = conn.Bucket(BUCKET_NAME)

    return bucket


def save_file_to_storage(key, file_):
    bucket = init()
    bucket.upload_fileobj(file_, key)


def fetch_file_from_storage(key):
    bucket = init()
    temp_file = BytesIO()
    bucket.download_fileobj(key, temp_file)
    temp_file.seek(0)
    return temp_file.read()
