from django.conf.urls import url

from staff.views import frontend_view

from staff.map.api import views as api_views
from staff.map import views
from staff.map.edit import equipment, room, region, conference_room, coworking_room, table

urlpatterns = [
    url(r'^$', frontend_view, name='map-home'),
    url(r'upload/?$', views.upload_image, name='map-upload'),
    url(r'upload/complete/(?P<file_name>[a-z\-\d]+)/?$', views.upload_image_complete, name='map-upload-complete'),

    url(r'^offices.json$', api_views.offices, name='map-offices'),
    url(r'^floors.json$', api_views.floors, name='map-floors'),
    url(r'^table.json$', api_views.table, name='map-table'),
    url(r'^tables.json$', api_views.tables, name='map-tables'),
    url(r'^room.json$', api_views.room, name='map-room'),
    url(r'^rooms.json$', api_views.rooms, name='map-rooms'),

    url(r'^rooms_usage.json$', api_views.rooms_usage, name='map-rooms-usage'),
    url(r'^export_rooms_usage$', api_views.export_rooms_usage, name='map-export-rooms-usage'),
    url(r'^export_rooms.xlsx$', api_views.export_rooms, name='map-rooms-export-xlsx'),

    url(r'^region.json$', api_views.region, name='map-region'),
    url(r'^regions.json$', api_views.regions, name='map-regions'),

    url(r'^conference_room.json$', api_views.conference_room, name='map-conference_room'),
    url(r'^conference_rooms.json$', api_views.conference_rooms, name='map-conference_rooms'),
    url(r'^coworking_room.json$', api_views.coworking_room, name='map-coworking_room'),
    url(r'^coworking_rooms.json$', api_views.coworking_rooms, name='map-coworking_rooms'),
    url(r'^special_rooms.json$', api_views.special_rooms, name='map-special_rooms'),
    url(r'^equipment.json$', api_views.equipment, name='map-equipment'),
    url(r'^single_equipment.json$', api_views.single_equipment, name='map-single_equipment'),
    url(r'^security_devices/$', api_views.security_devices, name='map-security'),

    url(r'^edit_history/$', api_views.export_edit_history, name='map-export_edit_history'),

    url(r'^staff_office_logs_import/$', api_views.staff_office_logs_import, name='map-staff-office-logs-import'),
    #  map-api urls
    url(r'^meta/$', views.meta, name='map-meta'),

    url(r'^equipment/edit/(?P<equipment_id>\d+)/?$',
        equipment.edit_equipment, name='map-edit_equipment'),
    url(r'^equipment/edit/?$',
        equipment.add_equipment, name='map-add_equipment'),
    url(r'^equipment/delete/(?P<equipment_id>\d+)/?$',
        equipment.delete_equipment, name='map-delete_equipment'),

    url(r'^room/edit/(?P<room_id>\d+)/?$',
        room.edit_room, name='map-edit_room'),
    url(r'^room/edit/?$',
        room.add_room, name='map-add_room'),
    url(r'^room/delete/(?P<room_id>\d+)/?$',
        room.delete_room, name='map-delete_room'),
    url(r'^room/bind/(?P<room_id>\d+)/?$',
        room.bind_room, name='map-bind_room'),
    url(r'^room/unbind/?$',
        room.unbind_room, name='map-unbind_room'),
    url(r'^mass_workplace_transfer/?$', room.mass_workplace_transfer, name='map-mass_workspace_transfer'),

    url(r'^region/edit/(?P<region_id>\d+)/?$',
        region.edit_region, name='map-edit_region'),
    url(r'^region/edit/?$',
        region.add_region, name='map-add_region'),
    url(r'^region/delete/(?P<region_id>\d+)/?$',
        region.delete_region, name='map-delete_region'),

    url(r'^conference_room/edit/(?P<conference_room_id>\d+)/?$',
        conference_room.edit_conferenceroom, name='map-edit_conferenceroom'),
    url(r'^conference_room/edit/?$',
        conference_room.add_conferenceroom, name='map-add_conferenceroom'),
    url(r'^conference_room/delete/(?P<conference_room_id>\d+)/?$',
        conference_room.delete_conferenceroom, name='map-delete_conferenceroom'),

    url(r'^coworking_room/edit/(?P<room_id>\d+)/?$',
        coworking_room.edit_coworkingroom, name='map-edit_coworkingroom'),
    url(r'^coworking_room/edit/?$',
        coworking_room.add_coworkingroom, name='map-add_coworkingroom'),
    url(r'^coworking_room/delete/(?P<room_id>\d+)/?$',
        coworking_room.delete_coworkingroom, name='map-delete_coworkingroom'),

    url(r'^table/edit/?$',
        table.add_table, name='map-add_table'),
    url(r'^table/edit/(?P<table_id>\d+)/?$',
        table.edit_table, name='map-edit_table'),
    url(r'^table/occupy/(?P<table_id>\d+)/?$',
        table.occupy_table, name='map-occupy_table'),
    url(r'^table/delete/(?P<table_id>\d+)/?$',
        table.delete_table, name='map-delete_table'),

    url(r'^book_table_for_person/?$',
        table.book_table_for_person, name='book-table-for-person'),
]
