from pymongo import MongoClient
from pymongo.read_preferences import ReadPreference

from django.conf import settings


def get_celery_broker_messages_collection():
    celery_db_name = 'staff'
    connection = MongoClient(
        host=settings.BROKER_URL,
        replicaSet=settings.MONGO_SET_NAME,
        read_preference=ReadPreference.PRIMARY_PREFERRED,
        connectTimeoutMS=settings.MONGO_TIMEOUT,
        username=settings.MONGO_USER,
        password=settings.MONGO_PASSWORD,
        authSource=celery_db_name,
    )
    db = connection[celery_db_name]
    return db['messages']
