from django.db import models

from staff.emission.django.emission_master.models import MasterLog


class FixedEmissionEvents(models.Model):
    log = models.ForeignKey(MasterLog, on_delete=models.CASCADE)
    created_at = models.DateTimeField(auto_now_add=True)


class FailedBpCodesUpdates(models.Model):
    proposal_id = models.CharField(max_length=25, verbose_name='_id заявки')
    login = models.CharField(max_length=50, db_index=True)
    code = models.IntegerField()
