from django.conf.urls import url

from staff.monitorings.views import (
    databases,
    firewall_rules,
    gap,
    groups,
    juggler,
    mongodb,
    oebs,
    passport,
    proposals,
    staff_api,
    taxi,
    trips,
    vacancies,
    workflow,
)

urlpatterns = [
    url(r'juggler/(?P<check_name>\w+)/?$', juggler.check_result_view, name='celery_queue_size'),

    url(r'celery-queue-size/?$', mongodb.check_celery_queue_size, name='celery_queue_size'),
    url(r'holes/?$', firewall_rules.check_fw_rules, name='holes'),
    url(
        r'staffapi-memberships-actuality/?$',
        staff_api.check_memberships_actuality,
        name='staffapi_memberships_actuality',
    ),
    url(r'staffapi-groups-consistency/?$', staff_api.check_group_consistency, name='staffapi_consistency'),
    url(r'problem-trips/?$', trips.check_problem_trips, name='trips_problems'),
    url(r'proposals_locked/?$', proposals.check_locked_proposals, name='check_locked_proposals'),
    url(r'proposals_oebs_push/?$', proposals.check_pushing_to_oebs, name='pushing_to_oebs'),
    url(r'proposals_persons_tickets/?$', proposals.check_persons_tickets, name='persons_tickets'),
    url(r'proposals_bp_changes/?$', proposals.check_bp_changes, name='bp_changes'),
    url(r'proposals_struct/?$', proposals.check_unpushed_struct_changes, name='struct_changes'),
    url(r'dead_proposal_tasks/?$', proposals.check_dead_proposal_tasks, name='bp_changes'),
    url(
        r'vacancies_hc_consistency/?$',
        vacancies.check_vacancy_headcount_consistency,
        name='vacancies_hc_consistency',
    ),
    url(r'databases/?$', databases.check_db, name='trips_problems'),
    url(r'pg_top/?$', databases.pg_top, name='pg_top'),
    url(r'taxi_auth/?$', taxi.check_taxi_api_auth, name='taxi_api_auth'),
    url(r'unblocked_passports/?$', passport.check_unblocked_passports, name='unblocked_passports'),
    url(r'groups_consistency/?$', groups.check_groups_consistency, name='check_groups_consistency'),
    url(r'gap_tickets/?$', gap.check_gap_tickets, name='gap_tickets'),
    url(r'check_success_rollup/?$', oebs.check_success_rollup, name='check_success_rollup'),
    url(r'check_staffapi_consistency/?$', staff_api.check_staffapi_consistency, name='staffapi_new_consistency'),
    url(
        r'check_office_and_organization_consistency/?$',
        oebs.check_office_and_organization_consistency,
        name='check_office_and_organization_consistency',
    ),
    url(r'workflow-consistency/?$', workflow.check_workflow_consistency, name='check_workflow_consistency'),
    url(r'check_unlinked_leave_balance/?$', oebs.check_unlinked_leave_balance, name='check_unlinked_leave_balance'),
    url(r'check_failed_bp_code_updates/?$', oebs.check_failed_bp_code_updates, name='check_failed_bp_code_updates'),
    url(r'check_mptt_trees/?$', groups.check_mptt_trees, name='check_mptt_trees'),
    url(r'check_export_changes/?$', workflow.check_export_changes_works, name='check_export_changes_work'),
]
