from datetime import date, timedelta

from django.http import JsonResponse

from staff.person.models import PersonBlockActions


def get_unblocked_passports():
    unblocked_person_logins = list(
        PersonBlockActions.objects
        .filter(is_passport_blocked=False, created_at__lt=date.today() - timedelta(minutes=5))
        .values_list('person__login', flat=True)
    )
    return unblocked_person_logins


def check_unblocked_passports(request):
    unblocked_person_logins = list(get_unblocked_passports())

    if not unblocked_person_logins:
        return JsonResponse(data={})

    return JsonResponse(data={'persons': unblocked_person_logins})
