from staff.lib.decorators import responding_json

from staff.departments.models.headcount import HeadcountPosition
from staff.departments.models.vacancy import Vacancy
from staff.femida.constants import VACANCY_STATUS
from staff.oebs.constants import PERSON_POSITION_STATUS


def get_vacancies_with_invalid_bp_status():
    valid_vacancy_statuses = (
        VACANCY_STATUS.ON_APPROVAL,
        VACANCY_STATUS.OFFER_ACCEPTED,
        VACANCY_STATUS.IN_PROGRESS,
        VACANCY_STATUS.OFFER_PROCESSING,
        VACANCY_STATUS.SUSPENDED,
    )
    valid_headcount_position_statuses = (
        PERSON_POSITION_STATUS.VACANCY_OPEN,
        PERSON_POSITION_STATUS.OFFER,
    )

    vacancy_codes = set(
        Vacancy.objects
        .filter(
            status__in=valid_vacancy_statuses,
            headcount_position_code__isnull=False,
        )
        .values_list('headcount_position_code', flat=True)
    )
    headcount_codes = set(
        HeadcountPosition.objects
        .filter(
            status__in=valid_headcount_position_statuses,
        )
        .values_list('code', flat=True)
    )

    result = {}
    if vacancy_codes - headcount_codes:
        result.update(**{
            'vacancies_without_known_headcount_count': len(vacancy_codes - headcount_codes),
            'vacancies_without_known_headcount_codes': vacancy_codes - headcount_codes,
        })
    if headcount_codes - vacancy_codes:
        result.update(**{
            'headcounts_without_known_vacancy_count': len(headcount_codes - vacancy_codes),
            'headcounts_without_known_vacancy_codes': headcount_codes - vacancy_codes,
        })
    return result


@responding_json
def check_vacancy_headcount_consistency(request):
    return get_vacancies_with_invalid_bp_status()
