from django.contrib import admin

from .forms import NavigationEditForm
from .models import Navigation


class NavigationAdmin(admin.ModelAdmin):
    form = NavigationEditForm

    list_display = (
        'application_id',
        'is_main',
        'position',
        'name',
        'url',
    )
    ordering = ('-is_main', 'position')
    list_filter = ('is_active', 'is_main')

    fields = (
        ('application_id', 'position'),
        'is_main',
        ('url', 'url_en'),
        ('name', 'name_en'),
        ('title', 'title_en'),
        'icon',
        'description',
        'is_active'
    )

    def save_model(self, request, obj, form, change):
        obj.last_modifier = request.user.get_profile()
        obj.save()


admin.site.register(Navigation, NavigationAdmin)
